jQuery(document).ready(function($) {
    $('form#contactForm').on('submit', function(e){
        $('#contact-us-status').show().text(ajax_contact_object.loading_message);
        jQuery('#contact-us-status').removeClass("success error");
        jQuery('#contact-us-status').addClass("alert-info");
        $.ajax({
            type: 'POST',
            dataType: 'json',
            url: ajax_contact_object.ajax_url,
            data: {
                'action': 'wpschool_ajax_contact',
                'g-recaptcha-response': grecaptcha.getResponse(),
                'name': $('#name').val(),
                'email': $('#email').val(),
                'phone': $('#phone').val(),
                'postalCode': $('#postalCode').val(),
                'companyName': $('#companyName').val(),
                'comment': $('#comment').val() },

            success: function(data){
                debugger;
                if(data.error==true){
                    jQuery('#contact-us-status').removeClass("alert-success");
                    jQuery('#contact-us-status').addClass("alert-danger");
                } else {
                    jQuery('#contact-us-status').addClass("alert-success");
                    jQuery('#contact-us-status').removeClass("alert-danger");
                }
                $('#contact-us-status').text(data.message);
            },
            error: function(response){

                jQuery('#contact-us-status').addClass("alert-danger");
                jQuery('#contact-us-status').removeClass("alert-success");
                jQuery('#contact-us-status').text("خطایی در هنگام ارتباط با سرور به وجود آمده است. لطفا دوباره امتحان کنید!");
            }
        });
        e.preventDefault();
    });
});