<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package WP_Bootstrap_Starter
 */

?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="profile" href="http://gmpg.org/xfn/11">
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
<?php wp_head(); ?>
<script>
    var j = jQuery.noConflict();
    j(window).scroll(function() {
        if (j(document).scrollTop() > 0) {
            j('nav.navbar-dark').addClass('navbar-scroll');
        } else {
            j('nav.navbar-dark').removeClass('navbar-scroll');
        }

        j('.animation-slide-up').each(function () {
            var imagePos = j(this).offset().top;
            var imageHeight = j(this).height();
            var topOfWindow = j(window).scrollTop() + 600;
            if (imagePos < topOfWindow + imageHeight) {
                j(this).addClass("animation-on-slide-up");
            } else {
                j(this).removeClass("animation-on-slide-up");
            }
        });
    });
    if (window.location.hash == '#product') {
        j(function () {
            j('html, body').animate({
                scrollTop: j("#product").offset().top - 99
            }, 500);
            return false;
        });
    }
    j(document).on('click', 'a[href^="#product"]', function (event) {
        if(window.location.href != '<?php echo esc_url( home_url( "/" )); ?>'){
            window.open('<?php echo esc_url( home_url( "/" )); ?>#product', '_self');
        }
        event.preventDefault();

        j('html, body').animate({
            scrollTop: j(j.attr(this, 'href')).offset().top - 99
        }, 500);
    });
    j(document).ready(function() {
        j(".home-header").on("mousemove", function(n){
            j(".home-header .bg .bg-1").animate({  textIndent: 0 },{
                step: function() {
                    var t=-(n.pageX/10), i=-(n.pageY/10);
                    j(this).css("transform","translate3d(" + t + "px, " + i + "px, 0)");
                },
                duration: 5,
                complete: function(){}
            });
        });
        j(".home-header").on("mousemove", function(n){
            j(".home-header .bg .bg-2").animate({  textIndent: 0 },{
                step: function() {
                    var t=-(n.pageX/17), i=-(n.pageY/17);
                    j(this).css("transform","translate3d(" + t + "px, " + i + "px, 0)");
                },
                duration: 5,
                complete: function(){}
            });
        });
        j(".home-header").on("mousemove", function(n){
            j(".home-header .bg .bg-3").animate({  textIndent: 0 },{
                step: function() {
                    var t=-(n.pageX/5), i=-(n.pageY/5);
                    j(this).css("transform","translate3d(" + t + "px, " + i + "px, 0)");
                },
                duration: 5,
                complete: function(){}
            });
        });
        j(".home-header").on("mousemove", function(n){
            j(".home-header .bg .bg-4").animate({  textIndent: 0 },{
                step: function() {
                    var t=-(n.pageX/8), i=-(n.pageY/8);
                    j(this).css("transform","translate3d(" + t + "px, " + i + "px, 0)");
                },
                duration: 5,
                complete: function(){}
            });
        });
        j(".home-header").on("mousemove", function(n){
            j(".home-header .bg .bg-5").animate({  textIndent: 0 },{
                step: function() {
                    var t=-(n.pageX/13), i=-(n.pageY/13);
                    j(this).css("transform","translate3d(" + t + "px, " + i + "px, 0)");
                },
                duration: 5,
                complete: function(){}
            });
        });
        j(".home-header .content .video").css("max-width", "100%");
        j(".home-header .content .video").css("max-height", "0");
        j(".home-header .content .text").css("max-height", "100%");
        j(".home-header .content .text .home-title .title-1").css("transform", "translateY(0)");
        j(".home-header .content .text .home-title .title-1").css("opacity", "1");
        j(".home-header .content .text .home-title .title-2").css("transform", "translateY(0)");
        j(".home-header .content .text .home-title .title-2").css("opacity", "1");
        j(".home-header .content .text .home-title .title-3").css("transform", "translateY(0)");
        j(".home-header .content .text .home-title .title-3").css("opacity", "1");
        j(".home-header .content .text .input-search").css("max-width", "100%");
        var i = 0;
        var navInterval = setInterval(function () {
            if(i<4) {
                j(".partner .nav li:eq(" + i + ") a").tab('show');
                i++;
            } else {
                i = 0;
                j(".partner .nav li:eq(" + i + ") a").tab('show');
                i++;
            }
        }, 3000);
        j(".partner .nav").on("click", function(){
            clearInterval(navInterval);
        });

        j('.home-carousel').carousel('dispose');
        j('.home-carousel').carousel({
            interval: 3000,
            cycle: true,
            pause: "null"
        });
        j('#home-carousel').on('mouseenter', function () {
            j('.home-carousel').carousel('dispose');
            j('.home-carousel').carousel({
                interval: 6000,
                cycle: true,
                pause: "null"
            });
        });
        j('#home-carousel').on('mouseleave', function () {
            j('.home-carousel').carousel('dispose');
            j('.home-carousel').carousel({
                interval: 3000,
                cycle: true,
                pause: "null"
            });
        });
    });
</script>
</head>
<body <?php body_class(); ?>>
    <?php if(!is_page_template( 'blank-page.php' ) && !is_page_template( 'blank-page-with-container.php' )): ?>
        <nav class="navbar fixed-top navbar-expand-xl navbar-dark bg-primary align-items-center justify-content-between px-4">
            <div class="d-flex justify-content-center">
                <button class="navbar-toggler mx-1" type="button" data-toggle="collapse" data-target=".navbar-collapse" aria-controls="" aria-expanded="false" aria-label="Toggle navigation">
                    <span class="navbar-toggler-icon"></span>
                </button>
                <a class="navbar-brand font-weight-bold mx-2" href="<?php echo esc_url( home_url( '/' )); ?>"><?php pll_e('راتین تجهیز البرز'); ?></a>
                <?php pll_the_languages( array( 'display_names_as' => 1, 'hide_current' => 1 ) ); ?>
            </div>
            <a class="navbar-brand d-xl-none d-lg-block d-md-block d-sm-block d-none" href="<?php echo esc_url( home_url( '/' )); ?>">
                <img src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/logo.png" class="d-inline-block align-top" alt="<?php pll_e('راتین تجهیز البرز'); ?>">
            </a>
            <?php
            wp_nav_menu(array(
            'theme_location'    => 'primary',
            'container'       => 'div',
            'container_id'    => 'navbar',
            'container_class' => 'collapse navbar-collapse justify-content-center align-items-end',
            'menu_id'         => false,
            'menu_class'      => 'navbar-nav text-center',
            'depth'           => 3,
            'fallback_cb'     => 'wp_bootstrap_navwalker::fallback',
            'walker'          => new wp_bootstrap_navwalker()
            ));
            ?>
            <a class="navbar-brand d-none d-xl-block" href="<?php echo esc_url( home_url( '/' )); ?>">
                <img src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/logo.png" class="d-inline-block align-top" alt="<?php pll_e('راتین تجهیز البرز'); ?>">
            </a>
        </nav>
        <?php if(is_front_page() && !get_theme_mod( 'header_banner_visibility' )): ?>

        <?php endif; ?>
    <?php endif; ?>
