<?php
/**
 * The main template file
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package WP_Bootstrap_Starter
 */

get_header(); ?>
    <div class="header-page bg-blue container-fluid px-5 d-flex justify-content-center align-items-center font-weight-bold">
        <h1 class="font-weight-bold text-center nowrap"><?php pll_e('مقالات'); ?></h1>
        <img src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" style="background-image:url('<?php echo get_template_directory_uri(); ?>/inc/assets/img/artical.png');">
    </div>
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
			<?php
			if(function_exists('bcn_display'))
			{
				bcn_display();
			}
			?>
        </ol>
    </nav>
    <div class="container-fluid post-list">
        <?php
            $paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
            $query = new WP_Query( array(
	            'posts_per_page' => 10,
	            'paged' => $paged
            ));
            while ( $query->have_posts() ) : $query->the_post();
                get_template_part( 'template-parts/content-list', get_post_format() );
            endwhile;
            wp_reset_postdata();
        ?>
        <div class="d-flex justify-content-center my-5">
            <?php bootstrap_pagination($query); ?>
        </div>
    </div>
<?php get_footer();
