<?php
/**
 * Template part for displaying page content
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package WP_Bootstrap_Starter
 */

$videos = get_post_meta(get_the_ID(), 'video', false);
$pdf = get_post_meta(get_the_ID(), 'pdf', true);

?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<div class="entry-content">
		<?php the_content(); ?>
        <?php if(!empty($videos) || !empty($pdf)) { ?>
            <div class="alert alert-info">
                <div class="row" dir="ltr">
	                <?php if(!empty($videos)) { ?>
                        <div class="col-md-<?php if(empty($pdf)) { ?>12<?php } else { ?>8<?php } ?>">
                            <h5 class="alert-heading" dir="auto"><i class="fa fa-play-circle" aria-hidden="true"></i> <?php pll_e('ویدیوهای مرتبط'); ?></h5>
                            <hr class="mt-0">
                            <div class="tab-content" id="v-pills-tabContent">
                                <?php foreach ($videos as $index => $video) { $video = explode(',', $video); ?>
                                    <div class="tab-pane fade<?php if($index==0) {?> show active<?php } ?>" id="v-pills-video<?php echo $index; ?>" role="tabpanel" aria-labelledby="v-pills-video<?php echo $index; ?>-tab">
                                        <?php echo $video[0]; ?>
                                    </div>
                                <?php } ?>
                            </div>
                            <div class="nav flex-column nav-pills" id="v-pills-tab" role="tablist" aria-orientation="vertical">
                                <?php foreach ($videos as $index => $video) { $video = explode(',', $video); ?>
                                    <a class="nav-link text-left<?php if($index==0) {?> active<?php } ?>" id="v-pills-video<?php echo $index; ?>-tab" data-toggle="pill" href="#v-pills-video<?php echo $index; ?>" role="tab" aria-controls="v-pills-video<?php echo $index; ?>" aria-selected="true">
                                        <i class="fa fa-play-circle" aria-hidden="true"></i> <?php echo $video[1]; ?>
                                    </a>
                                <?php } ?>
                            </div>
                        </div>
	                <?php } ?>
	                <?php if(!empty($pdf)) { ?>
                        <div class="col-md-<?php if(empty($videos)) { ?>12<?php } else { ?>4<?php } ?>">
                            <h5 class="alert-heading" dir="auto"><i class="fa fa-download" aria-hidden="true"></i> <?php pll_e('دانلودها'); ?></h5>
                            <hr class="mt-0">
                            <p class="text-center" dir="auto"><?php pll_e('برای اطلاعات بیشتر، لطفا این فایل را دانلود نمایید:'); ?></p>
                            <p><a href="<?php echo $pdf; ?>" target="_blank" role="button" class="btn btn-info btn-block">PDF - <?php the_title(); ?></a></p>
                        </div>
	                <?php } ?>
                </div>
            </div>
        <?php } ?>
        <?php
			wp_link_pages( array(
				'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'wp-bootstrap-starter' ),
				'after'  => '</div>',
			) );
		?>
	</div><!-- .entry-content -->
</article><!-- #post-## -->
