<?php
/**
 * Template part for displaying posts
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package WP_Bootstrap_Starter
 */

?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
    <div class="post-header bg-blue container-fluid p-5 d-flex flex-column justify-content-center align-items-center font-weight-bold">
		<?php
		if ( is_single() ) :
			the_title( '<h1 class="font-weight-bold text-center">', '</h1>' );
		else :
			the_title( '<h2><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
		endif;

		if ( 'post' === get_post_type() ) : ?>
		<div class="entry-meta">
			<?php wp_bootstrap_starter_posted_on(); ?>
		</div><!-- .entry-meta -->
		<?php
		endif; ?>
    </div>
	<div class="container">
        <div class="row justify-content-center">
            <div class="post-content col-lg-8 p-3">
                <div class="post-thumbnail">
                    <?php the_post_thumbnail(); ?>
                </div>
                <?php
                if ( is_single() ) :
                    the_content();
                else :
                    the_content( __( 'Continue reading <span class="meta-nav">&rarr;</span>', 'wp-bootstrap-starter' ) );
                endif;

                    wp_link_pages( array(
                        'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'wp-bootstrap-starter' ),
                        'after'  => '</div>',
                    ) );
                ?>
            </div>
        </div>
	</div>

	<footer class="entry-footer">
		<?php wp_bootstrap_starter_entry_footer(); ?>
	</footer><!-- .entry-footer -->
</article><!-- #post-## -->
