<?php
/**
 * Template Name: Adira
 */

get_header();
$url_num = '';
if(get_bloginfo('language')=='en-US'){
	$url_num = '-2';
}
?>
    <div class="header-page bg-blue container-fluid px-5 d-flex justify-content-center align-items-center font-weight-bold">
        <div class="row w-100">
            <div class="col-sm-8 offset-sm-2">
                <h1 class="font-weight-bold text-center"><?php pll_e('ماشین‌های ورق‌کاری'); ?></h1>
            </div>
        </div>
        <img src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" style="background-image:url('<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/LP_Premium/UplImg_35_34_251.jpg');">
    </div>
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
			<?php
			if(function_exists('bcn_display'))
			{
				bcn_display();
			}
			?>
        </ol>
    </nav>
    <div class="product container">
        <div class="my-4 py-4"></div>
        <div class="row">
            <div class="col-lg-5">
                <img class="w-100 img-fluid img-box-shadow" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/Press_Brakes.jpg">
            </div>
            <div class="col-lg-7 px-3 px-lg-5 pt-4 pt-lg-0">
                <h2 class="font-weight-bold"><a href="<?php echo esc_url( home_url( '/' )); ?>press_brakes<?php echo $url_num; ?>"><?php pll_e('پرس‌بریک‌ها'); ?></a></h2>
                <p><?php pll_e('تنوع وسیعی از پرس بریک ها، تمام نیازهای خم متداول و همچنین پروژه های خم به صورت سفارشی طراحی شده را پوشش می دهد. اگر نیاز شما از این هم فراتر رفت، Adira راه حل هایی دارد که می تواند آنها را برطرف نماید.'); ?></p>
                    <a href="<?php echo esc_url( home_url( '/' )); ?>press_brakes<?php echo $url_num; ?>" class="btn btn-primary btn-special position-absolute"><?php pll_e('اطلاعات بیشتر...'); ?></a>
                </p>
            </div>
        </div>
        <div class="my-5 py-5"></div>
        <div class="row">
            <div class="col-lg-5 d-block d-lg-none">
                <img class="w-100 img-fluid img-box-shadow" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/Laser.jpg">
            </div>
            <div class="col-lg-7 px-3 px-lg-5 pt-4 pt-lg-0">
                <h2 class="font-weight-bold"><a href="<?php echo esc_url( home_url( '/' )); ?>laser<?php echo $url_num; ?>"><?php pll_e('لیزر'); ?></a></h2>
                <p><?php pll_e('بیش از 10 سال است که Adira ماشین های برش لیزر را با موفقیت تولید می کند. این محصولات شامل موارد زیر می باشد: ماشین LE سطح استاندارد برای گستره ی وسیعی از کاربردها، ماشین LP کلاسیک با موتورهای خطی و عملکرد بالا در تمامی موقعیت ها، ماشین LF با یک لیزر فایبر نوین که به صورت ایده آل برای صفحات نازک و مواد صیقلی با مصرف و تعمیر و نگهداری پایین طراحی شده است. تمام ماشین های لیزر Adira، قابلیت اطمینان، دقت و عملکرد بالا را در برش فلز ارائه می دهند.'); ?></p>
                <p>
                    <a href="<?php echo esc_url( home_url( '/' )); ?>laser<?php echo $url_num; ?>" class="btn btn-primary btn-special position-absolute"><?php pll_e('اطلاعات بیشتر...'); ?></a>
                </p>
            </div>
            <div class="col-lg-5 d-none d-lg-block">
                <img class="w-100 img-fluid img-box-shadow" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/Laser.jpg">
            </div>
        </div>
        <div class="my-5 py-5"></div>
        <div class="row">
            <div class="col-lg-5">
                <img class="w-100 img-fluid img-box-shadow" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/Shears.jpg">
            </div>
            <div class="col-lg-7 px-3 px-lg-5 pt-4 pt-lg-0">
                <h2 class="font-weight-bold"><a href="<?php echo esc_url( home_url( '/' )); ?>shears<?php echo $url_num; ?>"><?php pll_e('گیوتین'); ?></a></h2>
                <p><?php pll_e('محصولات متنوع گیوتین برای گستره ی وسیعی از ضخامت ها و اندازه های ورق که تمامی نیازهای برش را برطرف می کنند. گیوتین های برش آونگی و برش عمودی، تک منظوره یا ترکیبی با حالت اتوماتیک برای بهبود عملکرد. محصولات به صورت زیر است: خط SM چند منظوره استاندارد، محصول GH Swing Cut همه کاره، GV برش عمودی با اندازه بزرگ'); ?></p>
                <p>
                    <a href="<?php echo esc_url( home_url( '/' )); ?>shears<?php echo $url_num; ?>" class="btn btn-primary btn-special position-absolute"><?php pll_e('اطلاعات بیشتر...'); ?></a>
                </p>
            </div>
        </div>
        <div class="my-5 py-5"></div>
        <div class="my-3 py-3"></div>
        <div class="row title mb-2">
            <div class="col-sm-12 pt-5">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="animation-slide-up">
                            <h1 class="text-center font-weight-bold text-nowrap"><?php pll_e('درباره‌ Adira'); ?></h1>
                        </div>
                        <i class="fa fa-commenting position-absolute bg bg-center" aria-hidden="true" style="top:-90px;"></i>
                    </div>
                    <div class="col-md-6 offset-md-3 col-sm-8 offset-sm-2 col-12 offset-0 position-relative">
                        <div class="d-flex flex-row justify-content-center align-items-center">
                            <hr style="width: 45%;">
                            <i class="fa fa-angle-double-down fa-2x text-center angle" aria-hidden="true"></i>
                            <hr style="width: 45%;">
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-sm-12">
                <p><?php pll_e('Adira بیش از 60 سال است که به طراحی، توسعه، تولید و نصب مدرن ترین ماشین آلات مشغول است.'); ?></p>
                <ul class="list-simple px-3">
                    <li><?php pll_e('سرمایه گذاری مداوم در تحقیقات علمی و توسعه فناوری به منظور ارائه ی همیشگی بهترین راه حل ها'); ?></li>
                    <li><?php pll_e('همکاری با دانشگاه ها و آزمایشگاه های مشهور تحقیقاتی'); ?></li>
                    <li><?php pll_e('کیفیت، دقت و قابلیت اطمینان راه حل های ما'); ?></li>
                    <li><?php pll_e('حداکثر عملکرد محصولات ما'); ?></li>
                    <li><?php pll_e('آمادگی و کارآمدی خدمات پس از فروش'); ?></li>
                    <li><?php pll_e('صادرات به بیش از 40 کشور جهان'); ?></li>
                    <li><?php pll_e('بیش از 80% گردش مالی ما خارج از کشور خود (پرتغال)'); ?></li>
                    <li><?php pll_e('بیشترین سهم بازار در کشور خود'); ?></li>
                    <li><?php pll_e('تولید در دو کارخانه تولیدی با 15000 متر مربع'); ?></li>
                </ul>
            </div>
        </div>
        <div class="my-3 py-3"></div>
    </div>
<?php
get_footer();
