<?php
/**
 * Template Name: HexaC
 */

get_header(); ?>
    <div class="header-page bg-blue container-fluid px-5 d-flex justify-content-center align-items-center font-weight-bold">
        <h1 class="font-weight-bold text-center"><?php pll_e('Hexa-C'); ?></h1>
        <img src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" style="background-image:url('<?php echo get_template_directory_uri(); ?>/inc/assets/img/HexaC/Adira_hexa_C_en-01.jpg');">
    </div>
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
			<?php
			if(function_exists('bcn_display'))
			{
				bcn_display();
			}
			?>
        </ol>
    </nav>
    <div class="product container mt-5">
        <div class="row mb-5 justify-content-center">
            <div class="col-lg-9">
                <div class="embed-responsive embed-responsive-16by9">
                    <video preload="none" loop="" autoplay="" muted="" data-replace="false">
                        <source src="<?php echo get_template_directory_uri(); ?>/inc/assets/media/HEXA-C.mp4" type="video/mp4">
                    </video>
                </div>
            </div>
        </div>
        <div class="row title">
            <div class="col-sm-12 mb-2">
                <div class="animation-slide-up">
                    <h3 class="text-right text-blue font-weight-bold mb-0"><?php pll_e('Hexa-C  حلقه گمشده خمکاری دقیق!'); ?></h3>
                </div>
                <div class="clearfix">
                    <hr class="w-50 float-right">
                    <i class="fa fa-angle-double-left fa-2x float-right" aria-hidden="true"></i>
                </div>
            </div>
        </div>
        <div class="row mb-5">
            <div class="col-lg-7">
                <p><?php pll_e('پرس بریک های  C فریم از دو طرف فریم کناری ( هوزینگ) و قسمت پایینی و تکیه گاههای اتصالی تشکیل شده است. و سیلندرهای فشار و بیم بالا رویه قسمت بالایی بدنه سوار می شوند.'); ?></p>
                <p><?php pll_e('به خاطر این فریم C  شکل، هنگام خمکاری علی رغم استحکام و تقویت بدنه، همواره خمشی به سمت عقب در بدنه اتفاق می افتد ( تصویر بالا) که در نتیجه آن ابزار بر روی  بیم بالا از مرکز ابزار در بیم پایین که ثابت است خارج می شود.'); ?></p>
                <p><?php pll_e('در تئوری، جکهای دو طرف بصورت کاملا سینکرونایز می بایست عمل کنند ؛ با این وجود در عمل اینطور نیست و تناژ مورد نیاز درهرجک تحت تاثیر عواملی همچون: تغییر آنالیز ورق در طول خم، تغییر سختی در طول خم،وجود سوراخ در قسمتی از خم و نیز تغییر ضخامت جزیی در طول خم و عواملی از این دست، سبب تغییر تناژ در دو سر خم می شود.'); ?></p>
                <p><?php pll_e('این تغییر تناژ در دو سر خمکاری، سبب تغییر مقدار خمش در بدنه دستگاه می شود و این مقدار خمش تحت تاثیر عوامل گفته شده در بالا در هر بار خمکاری متفاوت خواهد بود و در نتیجه آن، مقدار نیروی وارد شده به خم در هر بار خمکاری متفاوت شده، به این ترتیب در صورت عدم کنترل این خمش، زاویه خم در دو سر خمکاری یکسان نخواهد بود و نیز تکرار پذیری وجود ندارد.'); ?></p>
                <p><?php pll_e('بنابر این در صورتی که یک خم با کیفیت و با زوایای یکسان در دو سر میخواهید تولید کنید، اثر خمش بدنه کنترل و یا جبران شود.'); ?></p>
                <p><?php pll_e('برخی ماشین های گران قیمت از تجهیزاتی برای خواندن مقدار این خمش و در نهایت محاسبه مقدار نیروی جبران در کنترلر استفاده می کنند که این روش بسیار گران قیمت می شود و ماشینهای این چنینی ماشینهایی با قیمت بالا هستند.'); ?></p>
            </div>
            <div class="col-lg-5">
                <figure class="figure">
                    <img src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/HexaC/01.png" class="figure-img img-fluid img-thumbnail" alt="<?php pll_e('Hexa-C  حلقه گمشده خمکاری دقیق!'); ?>">
                    <figcaption class="figure-caption text-left"><?php pll_e('Frame deflection'); ?></figcaption>
                </figure>
            </div>
        </div>
        <div class="row mb-5">
            <div class="col-sm-12">
                <div class="alert alert-info" role="alert">
                    <p><?php pll_e('شرکت Adira  با نوآوری توانسته با اجرای مکانیزمی بسیار کارا و دقیق و تغییر طراحی بدنه، بطور کلی اثر خمش بدنه را در خمکاری کنترل کند و با یک روش ارزان و کاملا دقیق توانسته ماشینهای ارزان قیمت تر ولی با دقت و کیفیت ماشینهای گران قیمت بسازد.'); ?></p>
                    <p class="mb-0"><?php pll_e('Hexa-C  نوآوری شرکت Adira  و Patent  این شرکت می باشد که تحولی عظیم در صنعت خمکاری ایجاد نموده است.'); ?></p>
                </div>
            </div>
        </div>
        <div class="row mb-5 justify-content-center">
            <div class="col-lg-4">
                <img src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/HexaC/02.png" class="figure-img img-fluid img-thumbnail" alt="<?php pll_e('Adira Hexa-C Patent'); ?>">
            </div>
            <div class="col-lg-4">
                <img src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/HexaC/03.png" class="figure-img img-fluid img-thumbnail" alt="<?php pll_e('Adira Hexa-C Patent'); ?>">
            </div>
            <div class="col-lg-12"><p class="text-muted text-center"><?php pll_e('Adira Hexa-C Patent'); ?></p></div>
        </div>
        <div class="row mb-5">
            <div class="col-sm-12">
                <div class="alert alert-info" role="alert">
                    <p><?php pll_e('با Hexa-C حرکت بیم بالا از بدنه جدا شده و با وجود خمشهای متفاوت در بدنه ، مسیر حرکت بیم بالا درون یک ریل محور Y محدود شده است. به این ترتیب ابزار بالا همواره در راستای ابزار پایین خواهد بود.'); ?></p>
                </div>
            </div>
        </div>
        <div class="row mb-5 justify-content-center">
            <div class="col-lg-2 text-center">
                <figure class="figure">
                    <img src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/HexaC/04.png" class="figure-img img-fluid img-thumbnail" alt="<?php pll_e('Hexa-C Frame'); ?>">
                    <figcaption class="figure-caption text-center"><?php pll_e('Hexa-C Frame'); ?></figcaption>
                </figure>
            </div>
            <div class="col-lg-2 text-center">
                <figure class="figure">
                    <img src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/HexaC/05.png" class="figure-img img-fluid img-thumbnail" alt="<?php pll_e('Old Frame'); ?>">
                    <figcaption class="figure-caption text-center"><?php pll_e('Old Frame'); ?></figcaption>
                </figure>
            </div>
            <div class="col-lg-4 text-center">
                <figure class="figure">
                    <img src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/HexaC/06.png" class="figure-img img-fluid img-thumbnail" alt="<?php pll_e('Hexa-C'); ?>">
                    <figcaption class="figure-caption text-center"><?php pll_e('Hexa-C'); ?></figcaption>
                </figure>
            </div>
        </div>
        <div class="row title mb-5">
            <div class="col-sm-12 pt-5">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="animation-slide-up">
                            <h3 class="text-center text-blue font-weight-bold"><?php pll_e(' مقایسه خمکاری با سیستم قدیمی و سیستم جدید'); ?></h3>
                        </div>
                    </div>
                    <div class="col-md-6 offset-md-3 col-sm-8 offset-sm-2 col-12 offset-0 position-relative">
                        <div class="d-flex flex-row justify-content-center align-items-center">
                            <hr style="width: 45%;">
                            <i class="fa fa-angle-double-down fa-2x text-center angle" aria-hidden="true"></i>
                            <hr style="width: 45%;">
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row mb-5 justify-content-center">
            <div class="col-lg-10">
                <figure class="figure">
                    <img src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/HexaC/07.png" class="figure-img img-fluid img-thumbnail" alt="<?php pll_e('کاهش انحراف زاویه ای از 2 به 0.5 درجه!'); ?>">
                    <figcaption class="figure-caption text-center"><?php pll_e('کاهش انحراف زاویه ای از 2 به 0.5 درجه!'); ?></figcaption>
                </figure>
            </div>
        </div>
        <div class="row mb-5 justify-content-center">
            <div class="col-lg-8">
                <figure class="figure">
                    <img src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/HexaC/08.png" class="figure-img img-fluid img-thumbnail" alt="<?php pll_e('تفاوت استفاده و عدم استفاده از Hexa-C  در انحراف زاویه ای!'); ?>">
                    <figcaption class="figure-caption text-center"><?php pll_e('تفاوت استفاده و عدم استفاده از Hexa-C  در انحراف زاویه ای!'); ?></figcaption>
                </figure>
            </div>
        </div>
        <div class="row title mb-5">
            <div class="col-sm-12 pt-5">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="animation-slide-up">
                            <h3 class="text-center text-blue font-weight-bold"><?php pll_e('مزایای استفاده از Hexa-C'); ?></h3>
                        </div>
                    </div>
                    <div class="col-md-6 offset-md-3 col-sm-8 offset-sm-2 col-12 offset-0 position-relative">
                        <div class="d-flex flex-row justify-content-center align-items-center">
                            <hr style="width: 45%;">
                            <i class="fa fa-angle-double-down fa-2x text-center angle" aria-hidden="true"></i>
                            <hr style="width: 45%;">
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row mb-5">
            <div class="col-sm-8 offset-sm-2">
                <ul class="list-simple">
                    <li><?php pll_e('افزایش کیفیت و دقت خمکاری و تولید خمهایی یکسان و تکرار پذیر با حذف انحراف زاویه ای، بدست آمدن خمهایی بازوایای یکسان در دو سر و وسط هم'); ?></li>
                    <li><?php pll_e('افزایش بازدهی و افزایش تولید به واسطه تکرار پذیری بالا و کاهش زمان ست آپ'); ?></li>
                    <li><?php pll_e('کاهش استهلاک ماشین : همراستایی ابزار بالا و پایین باعث می شود با تناژ کمتری خم مورد نظر بدست بیاید'); ?></li>
                    <li><?php pll_e('کاهش استهلاک ابزار بواسطه همراستایی با ابزار پایین'); ?></li>
                </ul>
            </div>
        </div>
        <div class="my-3 py-3"></div>
    </div>
<?php
get_footer();
