<?php
/**
 * Template Name: ParmaStamp
 */

get_header(); ?>
    <div class="header-page full bg-blue container-fluid px-5 d-flex justify-content-center align-items-center font-weight-bold">
        <h1 class="font-weight-bold text-center"><?php pll_e('ابزار‌های پرس‌بریک'); ?></h1>
        <img src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" style="background-image:url('<?php echo get_template_directory_uri(); ?>/inc/assets/img/ParmaStamp.jpg');">
    </div>
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
			<?php
			if(function_exists('bcn_display'))
			{
				bcn_display();
			}
			?>
        </ol>
    </nav>
    <div class="product container mt-5">
        <div class="row title">
            <div class="col-sm-12 mb-2">
                <div class="animation-slide-up">
                    <h3 class="text-right text-blue font-weight-bold mb-0"><?php pll_e('ابزار پرس‌بریک استاندارد'); ?></h3>
                </div>
                <div class="clearfix">
                    <hr class="w-25 float-right">
                    <i class="fa fa-angle-double-left fa-2x float-right" aria-hidden="true"></i>
                </div>
            </div>
        </div>
        <div class="row mb-5" dir="rtl">
            <div class="col-lg-7" <?php if(is_rtl()){ ?>dir="rtl"<?php } else { ?>dir="ltr"<?php } ?>>
                <p><?php pll_e('محصولات Parma Stamp از آنجا که از نظر کیفی در مقایسه با رقبا از نظر خصوصیات فنی، مواد اولیه، استحکام و دقت برتر هستند، در جایگاه نخست بازار قرار دارند. تولیدکنندگان شناخته شده ی پرس بریک های هیدرولیک توسط Parma Stamp در زمینه ابزار استاندارد و خاص تجهیز می شوند.'); ?></p>
                <p><?php pll_e('ابزار Parma Stamp نه تنها در سطوح کاری بلکه در پیوست و سایر قسمت ها زمین می شوند که باعث یکنواختی زیبایی می گردد و تقارن، چهارگوش، مرکز و تراز بودن قالب حاصل شود. دقت تلورانس 0.01mm برای تعویض پدیری کامل گارانتی محصولات استاندارد Parma Stamp در زمان عرضه می باشد. شماره محصول، حداکثر بار و طول ابزار Parma Stamp برای تشخیص راحت کالا و در تطابق با استانداردهای ایمنی کار اروپا، توسط لیزر علامت گذاری شده است.'); ?></p>
            </div>
            <div class="col-lg-5 p-5 py-lg-0">
                <div id="standard-carousel" class="navbar-change carousel slide" data-ride="carousel" data-interval="3000" data-pause="hover">
                    <ol class="carousel-indicators">
                        <li data-target="#standard-carousel" data-slide-to="0" class="active"></li>
                        <li data-target="#standard-carousel" data-slide-to="1"></li>
                        <li data-target="#standard-carousel" data-slide-to="2"></li>
                        <li data-target="#standard-carousel" data-slide-to="3"></li>
                        <li data-target="#standard-carousel" data-slide-to="4"></li>
                    </ol>
                    <div class="carousel-inner">
                        <div class="carousel-item active">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/paramastamp/standard/utensili_standard_1.jpg" alt="">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/paramastamp/standard/utensili_standard_3.jpg" alt="">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/paramastamp/standard/utensili_standard_4.jpg" alt="">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/paramastamp/standard/utensili_standard_5.jpg" alt="">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/paramastamp/standard/utensili_standard_6.jpg" alt="">
                        </div>
                    </div>
                    <a class="carousel-control-prev" href="#standard-carousel" role="button" data-slide="prev">
                        <i class="fa fa-angle-<?php if(is_rtl()){ ?>right<?php } else { ?>left<?php } ?> fa-3x" aria-hidden="true"></i>
                        <span class="sr-only">Previous</span>
                    </a>
                    <a class="carousel-control-next" href="#standard-carousel" role="button" data-slide="next">
                        <i class="fa fa-angle-<?php if(is_rtl()){ ?>left<?php } else { ?>right<?php } ?> fa-3x" aria-hidden="true"></i>
                        <span class="sr-only">Next</span>
                    </a>
                </div>
            </div>
        </div>
        <div class="my-5 py-5"></div>
        <div class="row title">
            <div class="col-sm-12 mb-2">
                <div class="animation-slide-up">
                    <h3 class="text-left text-blue font-weight-bold mb-0"><?php pll_e('ابزار پرس‌بریک خاص'); ?></h3>
                </div>
                <div class="clearfix">
                    <hr class="w-25 float-left">
                    <i class="fa fa-angle-double-right fa-2x float-left" aria-hidden="true"></i>
                </div>
            </div>
        </div>
        <div class="row mb-5" dir="rtl">
            <div class="col-lg-5 p-5 py-lg-0">
                <div id="special-carousel" class="navbar-change carousel slide" data-ride="carousel" data-interval="3000" data-pause="hover">
                    <ol class="carousel-indicators">
                        <li data-target="#special-carousel" data-slide-to="0" class="active"></li>
                        <li data-target="#special-carousel" data-slide-to="1"></li>
                        <li data-target="#special-carousel" data-slide-to="2"></li>
                        <li data-target="#special-carousel" data-slide-to="3"></li>
                        <li data-target="#special-carousel" data-slide-to="4"></li>
                    </ol>
                    <div class="carousel-inner">
                        <div class="carousel-item active">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/paramastamp/special/Matrice-Registrabile-a-rulli-11.jpg" alt="">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/paramastamp/special/progettazione_2.jpg" alt="">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/paramastamp/special/utensili_speciali_3.jpg" alt="">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/paramastamp/special/utensili_speciali_5.jpg" alt="">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/paramastamp/special/utensili_speciali_6_2.jpg" alt="">
                        </div>
                    </div>
                    <a class="carousel-control-prev" href="#special-carousel" role="button" data-slide="prev">
                        <i class="fa fa-angle-<?php if(is_rtl()){ ?>right<?php } else { ?>left<?php } ?> fa-3x" aria-hidden="true"></i>
                        <span class="sr-only">Previous</span>
                    </a>
                    <a class="carousel-control-next" href="#special-carousel" role="button" data-slide="next">
                        <i class="fa fa-angle-<?php if(is_rtl()){ ?>left<?php } else { ?>right<?php } ?> fa-3x" aria-hidden="true"></i>
                        <span class="sr-only">Next</span>
                    </a>
                </div>
            </div>
            <div class="col-lg-7" <?php if(is_rtl()){ ?>dir="rtl"<?php } else { ?>dir="ltr"<?php } ?>>
                <p><?php pll_e('Parma Stamp نه تنها در طراحی و تولید همه نوع ابزار پرس بریک متخصص است، بلکه می تواند خطوط کامل ابزار برای ماشین های خمکاری پنل و مراکز خمکاری را به صورت کاملا مقاوم و با تلورانس 0.01mm عرضه نماید. عملیات حرارتی بر طبق نیازهای مختلف دوام و قدرت تعیین می شود که پیشرفته ترین راه حل فنی را به مشتریانمان با توجه به بودجه سرمایه گذاریشان توصیه می کنیم.'); ?></p>
                <p><?php pll_e('دپارتمان مهندسی Parma Stamp به دقت اندازه، استحکام و حداکثر بار ابزار را به وسیله ی نرم افزار رسم 3 بعدی و روش المان محدود اندازه گیری می نماید. بررسی ها تجهیزات موجود را در محیط کاری که وسیله در آن قرار می گیرد، در نظر می گیرند. پس از آزمایش در کارگاه Parma Stamp و اغلب بعد از تایید یک نمونه خم شیت متال، ابزار خاص برای مشتری ارسال می گردد بنابراین مشتری می تواند بدون فوت وقت نسبت به استفاده از ابزار اقدام نماید.'); ?></p>
            </div>
        </div>
        <div class="my-5 py-5"></div>
        <div class="row title">
            <div class="col-sm-12 mb-2">
                <div class="animation-slide-up">
                    <h3 class="text-right text-blue font-weight-bold mb-0"><?php pll_e('ابزار ماشین‌های خمکاری'); ?></h3>
                </div>
                <div class="clearfix">
                    <hr class="w-25 float-right">
                    <i class="fa fa-angle-double-left fa-2x float-right" aria-hidden="true"></i>
                </div>
            </div>
        </div>
        <div class="row mb-5" dir="rtl">
            <div class="col-lg-7" <?php if(is_rtl()){ ?>dir="rtl"<?php } else { ?>dir="ltr"<?php } ?>>
                <p><?php pll_e('ما می توانیم ابزار و تیغه ها را برای هر نوع ماشین پنل بندر تغییر دهیم: Codatto Trumpf, RAS, Weinbrenner Schroeder, Fasti, Schechtel, EHT, Jordi و غیره. Parma Stamp اصلاح سطوح، تیز کردن لبه ها و عملیات حرارتی را انجام می دهد.'); ?></p>
                <p><?php pll_e('ابزار Parma Stamp بر طبق ویژگی های فنی مختلف ماشین یا ورق، دارای سختکاری موضعی، سختکاری القائی یا سختکاری با نیتروژن، سندبلاست شده و زمین شده، می باشد. Parma Stamp می تواند به مشتریانش بهترین راه حل را برای هر نیاز منفرد توصیه کند.'); ?></p>
            </div>
            <div class="col-lg-5 p-5 py-lg-0">
                <div id="machin-carousel" class="navbar-change carousel slide" data-ride="carousel" data-interval="3000" data-pause="hover">
                    <ol class="carousel-indicators">
                        <li data-target="#machin-carousel" data-slide-to="0" class="active"></li>
                        <li data-target="#machin-carousel" data-slide-to="1"></li>
                        <li data-target="#machin-carousel" data-slide-to="2"></li>
                    </ol>
                    <div class="carousel-inner">
                        <div class="carousel-item active">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/paramastamp/machin/IMG_8714.jpg" alt="">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/paramastamp/machin/lame_pannellatrici_1.jpg" alt="">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/paramastamp/machin/lame_pannellatrici_2.jpg" alt="">
                        </div>
                    </div>
                    <a class="carousel-control-prev" href="#machin-carousel" role="button" data-slide="prev">
                        <i class="fa fa-angle-<?php if(is_rtl()){ ?>right<?php } else { ?>left<?php } ?> fa-3x" aria-hidden="true"></i>
                        <span class="sr-only">Previous</span>
                    </a>
                    <a class="carousel-control-next" href="#machin-carousel" role="button" data-slide="next">
                        <i class="fa fa-angle-<?php if(is_rtl()){ ?>left<?php } else { ?>right<?php } ?> fa-3x" aria-hidden="true"></i>
                        <span class="sr-only">Next</span>
                    </a>
                </div>
            </div>
        </div>
        <div class="my-5 py-5"></div>
        <div class="row title">
            <div class="col-sm-12 mb-2">
                <div class="animation-slide-up">
                    <h3 class="text-left text-blue font-weight-bold mb-0"><?php pll_e('قطعات یدکی'); ?></h3>
                </div>
                <div class="clearfix">
                    <hr class="w-25 float-left">
                    <i class="fa fa-angle-double-right fa-2x float-left" aria-hidden="true"></i>
                </div>
            </div>
        </div>
        <div class="row mb-5" dir="rtl">
            <div class="col-lg-5 p-5 py-lg-0">
                <div id="spare-carousel" class="navbar-change carousel slide" data-ride="carousel" data-interval="3000" data-pause="hover">
                    <ol class="carousel-indicators">
                        <li data-target="#spare-carousel" data-slide-to="0" class="active"></li>
                        <li data-target="#spare-carousel" data-slide-to="1"></li>
                        <li data-target="#spare-carousel" data-slide-to="2"></li>
                    </ol>
                    <div class="carousel-inner">
                        <div class="carousel-item active">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/paramastamp/spare/parti_ricambio_1.jpg" alt="">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/paramastamp/spare/parti_ricambio_2.jpg" alt="">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/paramastamp/spare/parti_ricambio_4.jpg" alt="">
                        </div>
                    </div>
                    <a class="carousel-control-prev" href="#spare-carousel" role="button" data-slide="prev">
                        <i class="fa fa-angle-<?php if(is_rtl()){ ?>right<?php } else { ?>left<?php } ?> fa-3x" aria-hidden="true"></i>
                        <span class="sr-only">Previous</span>
                    </a>
                    <a class="carousel-control-next" href="#spare-carousel" role="button" data-slide="next">
                        <i class="fa fa-angle-<?php if(is_rtl()){ ?>left<?php } else { ?>right<?php } ?> fa-3x" aria-hidden="true"></i>
                        <span class="sr-only">Next</span>
                    </a>
                </div>
            </div>
            <div class="col-lg-7" <?php if(is_rtl()){ ?>dir="rtl"<?php } else { ?>dir="ltr"<?php } ?>>
                <p><?php pll_e('به لطف تعداد بالای ابزار پیش ساخته برای ماشین های خم و پنل بندر مانندWEINBRENNER, RAS, SALVAGNINI, CODATTO و سایر ماشین ها، Parma Stamp قادر است قطعات یدکی یا مجموعه ابزار را طراحی و تولید نماید.'); ?></p>
                <p><?php pll_e('Parma Stamp می تواند خطوط کامل پایین نگهدارنده ها، قسمت های میانی و قطعات منفرد را جایگزین نموده یا می تواند مجموعه موجود را با ماشینکاری عالی مانند حالت اولش تیز نماید. ابزار Parma Stamp بر طبق ویژگی های فنی مختلف ماشین یا ورق، دارای سختکاری موضعی، سختکاری القائی یا سختکاری با نیتروژن، می باشد. به دلیل همکاری با یک شرکت خدمات پس از فروش مجزا،Parma Stamp می تواند نصب، نگهداری و پشتیبانی نرم افزاری را ارائه نماید.'); ?></p>
            </div>
        </div>
        <div class="my-5 py-5"></div>
        <div class="row title mb-5">
            <div class="col-sm-12 pt-5">
                <div class="row mb-5">
                    <div class="col-sm-12">
                        <div class="animation-slide-up">
                            <h3 class="text-center text-blue font-weight-bold text-nowrap"><?php pll_e('کاتالوگ ها'); ?></h3>
                        </div>
                    </div>
                    <div class="col-md-6 offset-md-3 col-sm-8 offset-sm-2 col-12 offset-0 position-relative">
                        <div class="d-flex flex-row justify-content-center align-items-center">
                            <hr style="width: 45%;">
                            <i class="fa fa-angle-double-down fa-2x text-center angle" aria-hidden="true"></i>
                            <hr style="width: 45%;">
                        </div>
                    </div>
                </div>
                <div class="row mb-5">
                    <div class="col p-2">
                        <a href="http://www.parmastamp.eu/en/cat/catalogue/amada-promecam-catalogue" target="_blank" role="button" class="btn btn-outline-info btn-lg btn-block"><i class="fa fa-book" aria-hidden="true"></i> Amada-Promecam</a>
                    </div>
                    <div class="col p-2">
                        <a href="http://www.parmastamp.eu/en/cat/catalogue/bystronic-beyeler-en" target="_blank" role="button" class="btn btn-outline-info btn-lg btn-block"><i class="fa fa-book" aria-hidden="true"></i> Bystronic-Beyeler</a>
                    </div>
                    <div class="col p-2">
                        <a href="http://www.parmastamp.eu/en/cat/catalogue/bystronic-hammerle-en" target="_blank" role="button" class="btn btn-outline-info btn-lg btn-block"><i class="fa fa-book" aria-hidden="true"></i> Bystronic-Hämmerle</a>
                    </div>
                    <div class="col p-2">
                        <a href="http://www.parmastamp.eu/en/cat/catalogue/eht-en" target="_blank" role="button" class="btn btn-outline-info btn-lg btn-block"><i class="fa fa-book" aria-hidden="true"></i> EHT</a>
                    </div>
                </div>
                <div class="row mb-5">
                    <div class="col p-2">
                        <a href="http://www.parmastamp.eu/en/cat/catalogue/lvd-en" target="_blank" role="button" class="btn btn-outline-info btn-lg btn-block"><i class="fa fa-book" aria-hidden="true"></i> LVD</a>
                    </div>
                    <div class="col p-2">
                        <a href="http://www.parmastamp.eu/en/cat/catalogue/weinbrenner-en" target="_blank" role="button" class="btn btn-outline-info btn-lg btn-block"><i class="fa fa-book" aria-hidden="true"></i> Weinbrenner</a>
                    </div>
                    <div class="col p-2">
                        <a href="http://www.parmastamp.eu/en/cat/catalogue/wila-trumpf-en" target="_blank" role="button" class="btn btn-outline-info btn-lg btn-block"><i class="fa fa-book" aria-hidden="true"></i> Wila-Trumpf</a>
                    </div>
                    <div class="col p-2">
                        <a href="http://www.parmastamp.eu/en/cat/catalogue/drawings-of-special-tools" target="_blank" role="button" class="btn btn-outline-info btn-lg btn-block"><i class="fa fa-book" aria-hidden="true"></i> Special tools</a>
                    </div>
                </div>
            </div>
        </div>
        <div class="my-5 py-5"></div>
        <div class="my-3 py-3"></div>
        <div class="row title mb-2">
            <div class="col-sm-12 pt-5">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="animation-slide-up">
                            <h1 class="text-center font-weight-bold"><?php pll_e('درباره‌ Parma Stamp'); ?></h1>
                        </div>
                        <i class="fa fa-commenting position-absolute bg bg-center" aria-hidden="true" style="top:-200px;"></i>
                    </div>
                    <div class="col-md-6 offset-md-3 col-sm-8 offset-sm-2 col-12 offset-0 position-relative">
                        <div class="d-flex flex-row justify-content-center align-items-center">
                            <hr style="width: 45%;">
                            <i class="fa fa-angle-double-down fa-2x text-center angle" aria-hidden="true"></i>
                            <hr style="width: 45%;">
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-6">
                <p><?php pll_e('Parma Stamp از سال 1974 تاکنون در زمینه ی تولید ابزار پرس بریک استاندارد و خاص فعالیت داشته و توانسته در میان مشتریانش به عنوان معتبرترین شرکت جهان شناخته شود. محصولات Parmastamp از آنجا که از نظر کیفی در مقایسه با رقبا از نظر خصوصیات فنی، مواد اولیه، استحکام و دقت برتر هستند، در جایگاه نخست بازار قرار دارند. شرکت های معتبری که ماشین آلات خمکاری شیت متال را تولید می کنند، مدت هاست که تجهیزات استاندارد و خاص خود را از این شرکت تهیه می کنند.'); ?></p>
                <p><?php pll_e('Parma Stamp نه تنها در طراحی و تولید همه نوع ابزار پرس بریک متخصص است، بلکه می تواند خطوط کامل ابزار برای ماشین های خمکاری پنل و مراکز خمکاری را به صورت کاملا مقاوم و با تلورانس 0.01mm عرضه نماید.'); ?></p>
                <p><?php pll_e('ابزارهای  این شرکت در صنایع مختلف مانند تولید کنندگان ماشین آلات، پیمانکاران، ساخت و سازهای شهری، مبلمان فلزی، فرم های در، وسایل نقلیه، هوانوردی، آسانسور، ساخت کشتی، ریل راه آهن، قطب های رعد و برق و بسیاری دیگر به کار می روند.'); ?></p>
                <p><?php pll_e('محصولات این شرکت امروزه در شرکت های بزرگ و کوچک جهان مانند FRANKE، RITTAL، KARDEX، RANNILA، SCHMITZ CARGO BULL، MAN، CANADAIR، URAL VAGON، ZAVOD، LIEBHERR، PISCINE CASTIGLIONE GROUP A&T که تعداد کمی از آنها هستند، نصب شده است.'); ?></p>
            </div>
            <div class="col-lg-6 d-flex align-items-center">
                <img class="img-fluid" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/paramastamp/about.jpg">
            </div>
        </div>
        <div class="my-3 py-3"></div>
    </div>
<?php
get_footer();
