<?php
/**
 * Template Name: Press Brakes
 */

get_header();
$url_num = '';
if(get_bloginfo('language')=='en-US'){
	$url_num = '-2';
}
?>
    <div class="header-page full bg-blue container-fluid p-2 p-sm-5 d-flex flex-column justify-content-center align-items-center">
        <h1 class="font-weight-bold text-center"><?php pll_e('پرس‌بریک‌ها'); ?></h1>
        <h4 class="font-weight-light text-center">
            <i class="fa fa-quote-right" aria-hidden="true"></i> <?php pll_e('تنوع وسیعی از پرس بریک ها، تمام نیازهای خم متداول و همچنین پروژه های خم به صورت سفارشی طراحی شده را پوشش می دهد. اگر نیاز شما از این هم فراتر رفت، Adira راه حل هایی دارد که می تواند آنها را برطرف نماید.'); ?> <i class="fa fa-quote-left" aria-hidden="true"></i>
        </h4>
        <img src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" style="background-image:url('<?php echo get_template_directory_uri(); ?>/inc/assets/img/Press_Brakes.jpg');">
    </div>
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
            <?php
                if(function_exists('bcn_display'))
                {
                    bcn_display();
                }
            ?>
        </ol>
    </nav>
    <div class="product container mt-5">
        <div class="row title">
            <div class="col-sm-12 mb-2">
                <div class="animation-slide-up">
                    <h3 class="text-right text-blue font-weight-bold mb-0" dir="auto"><?php pll_e('تکنولوژی Hexa-C'); ?></h3>
                </div>
                <div class="clearfix">
                    <hr class="w-25 float-right">
                    <i class="fa fa-angle-double-left fa-2x float-right" aria-hidden="true"></i>
                </div>
            </div>
        </div>
        <div class="row mb-5" dir="rtl">
            <div class="col-lg-5 px-5" <?php if(is_rtl()){ ?>dir="rtl"<?php } else { ?>dir="ltr"<?php } ?>>
                <p><?php pll_e('شرکت Adira  با نوآوری توانسته با اجرای مکانیزمی بسیار کارا و دقیق و تغییر طراحی بدنه، بطور کلی اثر خمش بدنه را در خمکاری کنترل کند و با یک روش ارزان و کاملا دقیق توانسته ماشینهای ارزان قیمت تر ولی با دقت و کیفیت ماشینهای گران قیمت بسازد.'); ?></p>
                <p><?php pll_e('Hexa-C  نوآوری شرکت Adira  و Patent  این شرکت می باشد که تحولی عظیم در صنعت خمکاری ایجاد نموده است.'); ?></p>
                <p class="text-center">
                    <a href="<?php echo esc_url( home_url( '/' )); ?>hexa_c<?php echo $url_num; ?>" class="btn btn-primary btn-special mx-2"><?php pll_e('اطلاعات بیشتر...'); ?></a>
                </p>
            </div>
            <div class="col-lg-7 px-5" <?php if(is_rtl()){ ?>dir="rtl"<?php } else { ?>dir="ltr"<?php } ?>>
	            <?php if(is_rtl()){ ?>
                    <img src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/HexaC/Adira_hexa_C-01.jpg" class="img-fluid w-100">
                <?php } else { ?>
                    <img src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/HexaC/Adira_hexa_C_en-01.jpg" class="img-fluid w-100">
                <?php } ?>
            </div>
        </div>
        <div class="my-5 py-5"></div>
        <div class="row title">
            <div class="col-sm-12 mb-2">
                <div class="animation-slide-up">
                    <h3 class="text-left text-blue font-weight-bold mb-0"><?php pll_e('PM Guimadira'); ?></h3>
                </div>
                <div class="clearfix">
                    <hr class="w-25 float-left">
                    <i class="fa fa-angle-double-right fa-2x float-left" aria-hidden="true"></i>
                </div>
                <h5 class="text-left text-blue"><?php pll_e('Hydraulic Series'); ?></h5>
            </div>
        </div>
        <div class="row mb-5" dir="rtl">
            <div class="col-lg-6 px-5 py-4 py-lg-0" <?php if(is_rtl()){ ?>dir="rtl"<?php } else { ?>dir="ltr"<?php } ?>>
                <div id="PM-Guimadira-carousel" class="navbar-change carousel slide" data-ride="carousel" data-interval="3000" data-pause="hover">
                    <ol class="carousel-indicators">
                        <li data-target="#PM-Guimadira-carousel" data-slide-to="0" class="active"></li>
                        <li data-target="#PM-Guimadira-carousel" data-slide-to="1"></li>
                        <li data-target="#PM-Guimadira-carousel" data-slide-to="2"></li>
                        <li data-target="#PM-Guimadira-carousel" data-slide-to="3"></li>
                        <li data-target="#PM-Guimadira-carousel" data-slide-to="4"></li>
                        <li data-target="#PM-Guimadira-carousel" data-slide-to="5"></li>
                    </ol>
                    <div class="carousel-inner">
                        <div class="carousel-item active">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/PM_Guimadira/UplImg_35_13_610.jpg" alt="PM Guimadira">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/PM_Guimadira/UplImg_35_13_611.jpg" alt="PM Guimadira">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/PM_Guimadira/UplImg_35_13_612.jpg" alt="PM Guimadira">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/PM_Guimadira/UplImg_35_13_613.jpg" alt="PM Guimadira">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/PM_Guimadira/UplImg_35_13_614.jpg" alt="PM Guimadira">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/PM_Guimadira/UplImg_35_13_615.jpg" alt="PM Guimadira">
                        </div>
                    </div>
                    <a class="carousel-control-prev" href="#PM-Guimadira-carousel" role="button" data-slide="prev">
                        <i class="fa fa-angle-<?php if(is_rtl()){ ?>right<?php } else { ?>left<?php } ?> fa-3x" aria-hidden="true"></i>
                        <span class="sr-only">Previous</span>
                    </a>
                    <a class="carousel-control-next" href="#PM-Guimadira-carousel" role="button" data-slide="next">
                        <i class="fa fa-angle-<?php if(is_rtl()){ ?>left<?php } else { ?>right<?php } ?> fa-3x" aria-hidden="true"></i>
                        <span class="sr-only">Next</span>
                    </a>
                </div>
            </div>
            <div class="col-lg-6 px-5" <?php if(is_rtl()){ ?>dir="rtl"<?php } else { ?>dir="ltr"<?php } ?>>
                <ul class="list-simple pt-3 pb-2">
                    <li class="font-weight-bold"> <?php pll_e('بهترین نسبت قیمت به کیفیت'); ?> </li>
                    <li class="font-weight-bold"> <?php pll_e('تکنولوژی Hexa-C'); ?> </li>
                    <li> <?php pll_e('5 مدل استاندارد: 135، 160 و 220 تن'); ?> </li>
                    <li> <?php pll_e('در دو اندازه : 3 و 4 متری'); ?> </li>
                    <li> <?php pll_e('سیستم ایمنی لیزر CE پیشرفته'); ?> </li>
                    <li> <?php pll_e('سهولت در استفاده'); ?> </li>
                    <li> <?php pll_e('راه حل اثبات شده'); ?> </li>
                    <li> <?php pll_e('طراحی و تولید شده در اروپا'); ?> </li>
                    <li> <?php pll_e('استانداردهای کیفی بالا'); ?> </li>
                    <li> <?php pll_e('قیمت رقابتی'); ?> </li>
                </ul>
                <p class="text-center">
                    <a href="http://www.adira.pt/clidocs/Gr38_118_0.pdf" target="_blank" class="btn btn-primary btn-special"><i class="fa fa-download" aria-hidden="true"></i> <?php pll_e('دانلود کاتالوگ'); ?></a>
                </p>
            </div>
        </div>
        <div class="my-5 py-5"></div>
        <div class="row title">
            <div class="col-sm-12 mb-2">
                <div class="animation-slide-up">
                    <h3 class="text-right text-blue font-weight-bold mb-0" dir="auto"><?php pll_e('PA Hexa C®'); ?></h3>
                </div>
                <div class="clearfix">
                    <hr class="w-25 float-right">
                    <i class="fa fa-angle-double-left fa-2x float-right" aria-hidden="true"></i>
                </div>
                <h5 class="text-right text-blue"><?php pll_e('Semi Hybrid'); ?></h5>
            </div>
        </div>
        <div class="row mb-5" dir="rtl">
            <div class="col-lg-6 px-5" <?php if(is_rtl()){ ?>dir="rtl"<?php } else { ?>dir="ltr"<?php } ?>>
                <ul class="list-simple pt-3 pb-2">
                    <li class="font-weight-bold"> <?php pll_e('جدیدترین تکنولوژی خمکاری'); ?> </li>
                    <li> <?php pll_e('دقیق'); ?> </li>
                    <li> <?php pll_e('سریع'); ?></li>
                    <li> <?php pll_e('پایدار'); ?> </li>
                    <li> <?php pll_e('انعطاف پذیر'); ?> </li>
                </ul>
                <p class="text-center">
                    <a href="http://www.adira.pt/clidocs/Gr38_115_0.pdf" class="btn btn-primary btn-special mx-2"><i class="fa fa-download" aria-hidden="true"></i> <?php pll_e('دانلود کاتالوگ'); ?></a>
                </p>
            </div>
            <div class="col-lg-6 px-5" <?php if(is_rtl()){ ?>dir="rtl"<?php } else { ?>dir="ltr"<?php } ?>>
                <div id="PA-Hexa-C-carousel" class="navbar-change carousel slide" data-ride="carousel" data-interval="3000" data-pause="hover">
                    <ol class="carousel-indicators">
                        <li data-target="#PA-Hexa-C-carousel" data-slide-to="0" class="active"></li>
                        <li data-target="#PA-Hexa-C-carousel" data-slide-to="1"></li>
                        <li data-target="#PA-Hexa-C-carousel" data-slide-to="2"></li>
                        <li data-target="#PA-Hexa-C-carousel" data-slide-to="3"></li>
                        <li data-target="#PA-Hexa-C-carousel" data-slide-to="4"></li>
                        <li data-target="#PA-Hexa-C-carousel" data-slide-to="5"></li>
                        <li data-target="#PA-Hexa-C-carousel" data-slide-to="6"></li>
                        <li data-target="#PA-Hexa-C-carousel" data-slide-to="7"></li>
                        <li data-target="#PA-Hexa-C-carousel" data-slide-to="8"></li>
                        <li data-target="#PA-Hexa-C-carousel" data-slide-to="9"></li>
                    </ol>
                    <div class="carousel-inner">
                        <div class="carousel-item active">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/PA_Hexa_C/UplImg_35_66_407.jpg" alt="PA Hexa C">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/PA_Hexa_C/UplImg_35_66_408.jpg" alt="PA Hexa C">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/PA_Hexa_C/UplImg_35_66_409.jpg" alt="PA Hexa C">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/PA_Hexa_C/UplImg_35_66_423.jpg" alt="PA Hexa C">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/PA_Hexa_C/UplImg_35_66_424.jpg" alt="PA Hexa C">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/PA_Hexa_C/UplImg_35_66_425.jpg" alt="PA Hexa C">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/PA_Hexa_C/UplImg_35_66_426.jpg" alt="PA Hexa C">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/PA_Hexa_C/UplImg_35_66_427.jpg" alt="PA Hexa C">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/PA_Hexa_C/UplImg_35_66_428.jpg" alt="PA Hexa C">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/PA_Hexa_C/UplImg_35_66_513.jpg" alt="PA Hexa C">
                        </div>
                    </div>
                    <a class="carousel-control-prev" href="#PA-Hexa-C-carousel" role="button" data-slide="prev">
                        <i class="fa fa-angle-<?php if(is_rtl()){ ?>right<?php } else { ?>left<?php } ?> fa-3x" aria-hidden="true"></i>
                        <span class="sr-only">Previous</span>
                    </a>
                    <a class="carousel-control-next" href="#PA-Hexa-C-carousel" role="button" data-slide="next">
                        <i class="fa fa-angle-<?php if(is_rtl()){ ?>left<?php } else { ?>right<?php } ?> fa-3x" aria-hidden="true"></i>
                        <span class="sr-only">Next</span>
                    </a>
                </div>
            </div>
        </div>
        <div class="my-5 py-5"></div>
        <div class="row title">
            <div class="col-sm-12 mb-2">
                <div class="animation-slide-up">
                    <h3 class="text-left text-blue font-weight-bold mb-0"><?php pll_e('PF سریع'); ?></h3>
                </div>
                <div class="clearfix">
                    <hr class="w-25 float-left">
                    <i class="fa fa-angle-double-right fa-2x float-left" aria-hidden="true"></i>
                </div>
                <h5 class="text-left text-blue"><?php pll_e('Full Hybrid'); ?></h5>
            </div>
        </div>
        <div class="row mb-5" dir="rtl">
            <div class="col-lg-6 px-5 py-4 py-lg-0" <?php if(is_rtl()){ ?>dir="rtl"<?php } else { ?>dir="ltr"<?php } ?>>
                <div id="PF-Fast-carousel" class="navbar-change carousel slide" data-ride="carousel" data-interval="3000" data-pause="hover">
                    <ol class="carousel-indicators">
                        <li data-target="#PF-Fast-carousel" data-slide-to="0" class="active"></li>
                        <li data-target="#PF-Fast-carousel" data-slide-to="1"></li>
                        <li data-target="#PF-Fast-carousel" data-slide-to="2"></li>
                        <li data-target="#PF-Fast-carousel" data-slide-to="3"></li>
                        <li data-target="#PF-Fast-carousel" data-slide-to="4"></li>
                    </ol>
                    <div class="carousel-inner">
                        <div class="carousel-item active">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/PF_Fast/UplImg_35_28_498.jpg" alt="<?php pll_e('PF سریع'); ?>">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/PF_Fast/UplImg_35_28_501.jpg" alt="<?php pll_e('PF سریع'); ?>">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/PF_Fast/UplImg_35_28_503.jpg" alt="<?php pll_e('PF سریع'); ?>">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/PF_Fast/UplImg_35_28_504.jpg" alt="<?php pll_e('PF سریع'); ?>">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/PF_Fast/UplImg_35_28_515.jpg" alt="<?php pll_e('PF سریع'); ?>">
                        </div>
                    </div>
                    <a class="carousel-control-prev" href="#PF-Fast-carousel" role="button" data-slide="prev">
                        <i class="fa fa-angle-<?php if(is_rtl()){ ?>right<?php } else { ?>left<?php } ?> fa-3x" aria-hidden="true"></i>
                        <span class="sr-only">Previous</span>
                    </a>
                    <a class="carousel-control-next" href="#PF-Fast-carousel" role="button" data-slide="next">
                        <i class="fa fa-angle-<?php if(is_rtl()){ ?>left<?php } else { ?>right<?php } ?> fa-3x" aria-hidden="true"></i>
                        <span class="sr-only">Next</span>
                    </a>
                </div>
            </div>
            <div class="col-lg-6 px-5" <?php if(is_rtl()){ ?>dir="rtl"<?php } else { ?>dir="ltr"<?php } ?>>
                <ul class="list-simple pt-3 pb-2">
                    <li class="font-weight-bold"> <?php pll_e('در بالاترین رده پرس بریک ها'); ?> </li>
                    <li> <?php pll_e('سرعت بارگذاری، خمکاری و بازگشت بالا'); ?> </li>
                    <li> <?php pll_e('دهانه عریض و کورس وسیع'); ?></li>
                    <li> <?php pll_e('عملکرد بالا'); ?> </li>
                    <li> <?php pll_e('تغییر سرعت تنها 2mm بالای صفحه'); ?> </li>
                    <li> <?php pll_e('نهایت دقت'); ?></li>
                    <li> <?php pll_e('بهترین مثال نوآوری و تکنولوژی در خمکاری'); ?> </li>
                    <li> <?php pll_e('ابزار انعطاف پذیر و گزینه های با کارآمدی بالا'); ?> </li>
                    <li> <?php pll_e('ارگونومی، طراحی و ایمنی'); ?> </li>
                    <li> <?php pll_e('ماشین ایده آل برای یکپارچه سازی با سلول های روباتیک'); ?> </li>
                    <li> <?php pll_e('بهترین انتخاب برای حداکثر عملکرد'); ?> </li>
                </ul>
                <p class="text-center">
                    <a href="http://www.adira.pt/clidocs/Gr38_113_0.pdf" class="btn btn-primary btn-special"><i class="fa fa-download" aria-hidden="true"></i> <?php pll_e('دانلود کاتالوگ'); ?></a>
                </p>
            </div>
        </div>
        <div class="my-5 py-5"></div>
        <div class="row title">
            <div class="col-sm-12 mb-2">
                <div class="animation-slide-up">
                    <h3 class="text-right text-blue font-weight-bold mb-0"><?php pll_e('GreenBender'); ?></h3>
                </div>
                <div class="clearfix">
                    <hr class="w-25 float-right">
                    <i class="fa fa-angle-double-left fa-2x float-right" aria-hidden="true"></i>
                </div>
                <h5 class="text-right text-blue"><?php pll_e('Full Hybrid H-Frame'); ?></h5>
            </div>
        </div>
        <div class="row mb-5" dir="rtl">
            <div class="col-lg-6 px-5" <?php if(is_rtl()){ ?>dir="rtl"<?php } else { ?>dir="ltr"<?php } ?>>
                <ul class="list-simple pt-3 pb-2">
                    <li class="font-weight-bold"> <?php pll_e('تکنولوژی خمکاری هایبرید'); ?> </li>
                    <li class="font-weight-bold"> <?php pll_e('خلاقیت'); ?> </li>
                    <li class="font-weight-bold"> <?php pll_e('دوستدار محیط زیست'); ?> </li>
                    <li> <?php pll_e('دقت خارق العاده'); ?> </li>
                    <li> <?php pll_e('تکنولوژی گرین داینامیک  هایبرید'); ?> </li>
                    <li> <?php pll_e('تعمیر و نگهداری حداقل'); ?> </li>
                    <li> <?php pll_e('انتخاب ایده آل برای مشتریان قرن 21'); ?></li>
                </ul>
                <p class="text-center">
                    <a href="http://www.adira.pt/clidocs/Gr38_85_0.pdf" class="btn btn-primary btn-special"><i class="fa fa-download" aria-hidden="true"></i> <?php pll_e('دانلود کاتالوگ'); ?></a>
                </p>
            </div>
            <div class="col-lg-6 px-5 py-4 py-lg-0" <?php if(is_rtl()){ ?>dir="rtl"<?php } else { ?>dir="ltr"<?php } ?>>
                <div id="GreenBender-carousel" class="navbar-change carousel slide" data-ride="carousel" data-interval="3000" data-pause="hover">
                    <ol class="carousel-indicators">
                        <li data-target="#GreenBender-carousel" data-slide-to="0" class="active"></li>
                        <li data-target="#GreenBender-carousel" data-slide-to="1"></li>
                        <li data-target="#GreenBender-carousel" data-slide-to="2"></li>
                        <li data-target="#GreenBender-carousel" data-slide-to="3"></li>
                        <li data-target="#GreenBender-carousel" data-slide-to="4"></li>
                        <li data-target="#GreenBender-carousel" data-slide-to="5"></li>
                        <li data-target="#GreenBender-carousel" data-slide-to="6"></li>
                        <li data-target="#GreenBender-carousel" data-slide-to="7"></li>
                        <li data-target="#GreenBender-carousel" data-slide-to="8"></li>
                    </ol>
                    <div class="carousel-inner">
                        <div class="carousel-item active">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/GreenBender/UplImg_35_62_196.jpg" alt="GreenBender">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/GreenBender/UplImg_35_62_197.jpg" alt="GreenBender">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/GreenBender/UplImg_35_62_198.jpg" alt="GreenBender">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/GreenBender/UplImg_35_62_199.jpg" alt="GreenBender">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/GreenBender/UplImg_35_62_200.jpg" alt="GreenBender">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/GreenBender/UplImg_35_62_201.jpg" alt="GreenBender">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/GreenBender/UplImg_35_62_202.jpg" alt="GreenBender">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/GreenBender/UplImg_35_62_245.jpg" alt="GreenBender">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/GreenBender/UplImg_35_62_410.jpg" alt="GreenBender">
                        </div>
                    </div>
                    <a class="carousel-control-prev" href="#GreenBender-carousel" role="button" data-slide="prev">
                        <i class="fa fa-angle-<?php if(is_rtl()){ ?>right<?php } else { ?>left<?php } ?> fa-3x" aria-hidden="true"></i>
                        <span class="sr-only">Previous</span>
                    </a>
                    <a class="carousel-control-next" href="#GreenBender-carousel" role="button" data-slide="next">
                        <i class="fa fa-angle-<?php if(is_rtl()){ ?>left<?php } else { ?>right<?php } ?> fa-3x" aria-hidden="true"></i>
                        <span class="sr-only">Next</span>
                    </a>
                </div>
            </div>
        </div>
        <div class="my-5 py-5"></div>
        <div class="row title">
            <div class="col-sm-12 mb-2">
                <div class="animation-slide-up">
                    <h3 class="text-left text-blue font-weight-bold mb-0"><?php pll_e('Bluebender'); ?></h3>
                </div>
                <div class="clearfix">
                    <hr class="w-25 float-left">
                    <i class="fa fa-angle-double-right fa-2x float-left" aria-hidden="true"></i>
                </div>
                <h5 class="text-left text-blue"><?php pll_e('Full Electrical'); ?></h5>
            </div>
        </div>
        <div class="row mb-5" dir="rtl">
            <div class="col-lg-6 px-5 py-4 py-lg-0" <?php if(is_rtl()){ ?>dir="rtl"<?php } else { ?>dir="ltr"<?php } ?>>
                <div id="Bluebender-carousel" class="navbar-change carousel slide" data-ride="carousel" data-interval="3000" data-pause="hover">
                    <ol class="carousel-indicators">
                        <li data-target="#Bluebender-carousel" data-slide-to="0" class="active"></li>
                        <li data-target="#Bluebender-carousel" data-slide-to="1"></li>
                        <li data-target="#Bluebender-carousel" data-slide-to="2"></li>
                        <li data-target="#Bluebender-carousel" data-slide-to="3"></li>
                        <li data-target="#Bluebender-carousel" data-slide-to="4"></li>
                    </ol>
                    <div class="carousel-inner">
                        <div class="carousel-item active">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/Bluebender/UplImg_35_65_508.jpg" alt="Bluebender">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/Bluebender/UplImg_35_65_509.jpg" alt="Bluebender">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/Bluebender/UplImg_35_65_510.jpg" alt="Bluebender">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/Bluebender/UplImg_35_65_512.jpg" alt="Bluebender">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/Bluebender/UplImg_35_65_516.jpg" alt="Bluebender">
                        </div>
                    </div>
                    <a class="carousel-control-prev" href="#Bluebender-carousel" role="button" data-slide="prev">
                        <i class="fa fa-angle-<?php if(is_rtl()){ ?>right<?php } else { ?>left<?php } ?> fa-3x" aria-hidden="true"></i>
                        <span class="sr-only">Previous</span>
                    </a>
                    <a class="carousel-control-next" href="#Bluebender-carousel" role="button" data-slide="next">
                        <i class="fa fa-angle-<?php if(is_rtl()){ ?>left<?php } else { ?>right<?php } ?> fa-3x" aria-hidden="true"></i>
                        <span class="sr-only">Next</span>
                    </a>
                </div>
            </div>
            <div class="col-lg-6 px-5" <?php if(is_rtl()){ ?>dir="rtl"<?php } else { ?>dir="ltr"<?php } ?>>
                <ul class="list-simple py-5">
                    <li class="font-weight-bold"> <?php pll_e('پرس بریک الکتریکی'); ?></li>
                    <li> <?php pll_e('تکنولوژی پایدار'); ?> </li>
                    <li> <?php pll_e('ماشین بدون آلودگی'); ?> </li>
                    <li> <?php pll_e('سریع'); ?></li>
                </ul>
                <p class="text-center">
                    <a href="http://www.adira.pt/clidocs/Gr38_112_0.pdf" class="btn btn-primary btn-special"><i class="fa fa-download" aria-hidden="true"></i> <?php pll_e('دانلود کاتالوگ'); ?></a>
                </p>
            </div>
        </div>
        <div class="my-5 py-5"></div>
        <div class="row title">
            <div class="col-sm-12 mb-2">
                <div class="animation-slide-up">
                    <h3 class="text-right text-blue font-weight-bold mb-0"><?php pll_e('PH مخصوص کارهای سنگین'); ?></h3>
                </div>
                <div class="clearfix">
                    <hr class="w-25 float-right">
                    <i class="fa fa-angle-double-left fa-2x float-right" aria-hidden="true"></i>
                </div>
            </div>
        </div>
        <div class="row mb-5" dir="rtl">
            <div class="col-lg-6 px-5" <?php if(is_rtl()){ ?>dir="rtl"<?php } else { ?>dir="ltr"<?php } ?>>
                <ul class="list-simple py-5">
                    <li class="font-weight-bold"> <?php pll_e('پرس بریک های سایز بزرگ'); ?> </li>
                    <li> <?php pll_e('ماشین های تناژ بالا'); ?> </li>
                    <li> <?php pll_e('طول خمکاری زیاد'); ?> </li>
                    <li> <?php pll_e('راهکار تاندم'); ?> </li>
                    <li> <?php pll_e('کاملا قابل سفارشی سازی'); ?> </li>
                    <li> <?php pll_e('استحکام، قابلیت اطمینان و ایمنی'); ?> </li>
                    <li> <?php pll_e('انتخاب ایده آل برای وظایف سنگین'); ?></li>
                </ul>
                <p class="text-center">
                    <a href="http://www.adira.pt/clidocs/Gr38_22_0.pdf" class="btn btn-primary btn-special"><i class="fa fa-download" aria-hidden="true"></i> <?php pll_e('دانلود کاتالوگ'); ?></a>
                </p>
            </div>
            <div class="col-lg-6 px-5" <?php if(is_rtl()){ ?>dir="rtl"<?php } else { ?>dir="ltr"<?php } ?>>
                <div id="PH-Heavy-Duty-carousel" class="navbar-change carousel slide" data-ride="carousel" data-interval="3000" data-pause="hover">
                    <ol class="carousel-indicators">
                        <li data-target="#PH-Heavy-Duty-carousel" data-slide-to="0" class="active"></li>
                        <li data-target="#PH-Heavy-Duty-carousel" data-slide-to="1"></li>
                        <li data-target="#PH-Heavy-Duty-carousel" data-slide-to="2"></li>
                        <li data-target="#PH-Heavy-Duty-carousel" data-slide-to="3"></li>
                        <li data-target="#PH-Heavy-Duty-carousel" data-slide-to="4"></li>
                        <li data-target="#PH-Heavy-Duty-carousel" data-slide-to="5"></li>
                        <li data-target="#PH-Heavy-Duty-carousel" data-slide-to="6"></li>
                        <li data-target="#PH-Heavy-Duty-carousel" data-slide-to="7"></li>
                        <li data-target="#PH-Heavy-Duty-carousel" data-slide-to="8"></li>
                        <li data-target="#PH-Heavy-Duty-carousel" data-slide-to="9"></li>
                    </ol>
                    <div class="carousel-inner">
                        <div class="carousel-item active">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/PH_Heavy_Duty/UplImg_35_29_12.png" alt="<?php pll_e('PH مخصوص کارهای سنگین'); ?>">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/PH_Heavy_Duty/UplImg_35_29_13.jpg" alt="<?php pll_e('PH مخصوص کارهای سنگین'); ?>">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/PH_Heavy_Duty/UplImg_35_29_14.jpg" alt="<?php pll_e('PH مخصوص کارهای سنگین'); ?>">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/PH_Heavy_Duty/UplImg_35_29_115.jpg" alt="<?php pll_e('PH مخصوص کارهای سنگین'); ?>">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/PH_Heavy_Duty/UplImg_35_29_188.jpg" alt="<?php pll_e('PH مخصوص کارهای سنگین'); ?>">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/PH_Heavy_Duty/UplImg_35_29_189.jpg" alt="<?php pll_e('PH مخصوص کارهای سنگین'); ?>">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/PH_Heavy_Duty/UplImg_35_29_190.jpg" alt="<?php pll_e('PH مخصوص کارهای سنگین'); ?>">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/PH_Heavy_Duty/UplImg_35_29_191.jpg" alt="<?php pll_e('PH مخصوص کارهای سنگین'); ?>">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/PH_Heavy_Duty/UplImg_35_29_429.jpg" alt="<?php pll_e('PH مخصوص کارهای سنگین'); ?>">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/PH_Heavy_Duty/UplImg_35_29_431.png" alt="<?php pll_e('PH مخصوص کارهای سنگین'); ?>">
                        </div>
                    </div>
                    <a class="carousel-control-prev" href="#PH-Heavy-Duty-carousel" role="button" data-slide="prev">
                        <i class="fa fa-angle-<?php if(is_rtl()){ ?>right<?php } else { ?>left<?php } ?> fa-3x" aria-hidden="true"></i>
                        <span class="sr-only">Previous</span>
                    </a>
                    <a class="carousel-control-next" href="#PH-Heavy-Duty-carousel" role="button" data-slide="next">
                        <i class="fa fa-angle-<?php if(is_rtl()){ ?>left<?php } else { ?>right<?php } ?> fa-3x" aria-hidden="true"></i>
                        <span class="sr-only">Next</span>
                    </a>
                </div>
            </div>
        </div>
        <div class="my-5 py-5"></div>
        <div class="row title">
            <div class="col-sm-12 mb-2">
                <div class="animation-slide-up">
                    <h3 class="text-left text-blue font-weight-bold mb-0"><?php pll_e('سلول های خمکاری (Bending Cell)'); ?></h3>
                </div>
                <div class="clearfix">
                    <hr class="w-25 float-left">
                    <i class="fa fa-angle-double-right fa-2x float-left" aria-hidden="true"></i>
                </div>
            </div>
        </div>
        <div class="row mb-5" dir="rtl">
            <div class="col-lg-6 px-5 py-4 py-lg-0" <?php if(is_rtl()){ ?>dir="rtl"<?php } else { ?>dir="ltr"<?php } ?>>
                <div id="Bending-Cells-carousel" class="navbar-change carousel slide" data-ride="carousel" data-interval="3000" data-pause="hover">
                    <ol class="carousel-indicators">
                        <li data-target="#Bending-Cells-carousel" data-slide-to="0" class="active"></li>
                        <li data-target="#Bending-Cells-carousel" data-slide-to="1"></li>
                        <li data-target="#Bending-Cells-carousel" data-slide-to="2"></li>
                        <li data-target="#Bending-Cells-carousel" data-slide-to="3"></li>
                        <li data-target="#Bending-Cells-carousel" data-slide-to="4"></li>
                    </ol>
                    <div class="carousel-inner">
                        <div class="carousel-item active">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/BendingCells/UplImg_35_68_356.jpg" alt="<?php pll_e('سلول های خمکاری (Bending Cell)'); ?>">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/BendingCells/UplImg_35_68_357.jpg" alt="<?php pll_e('سلول های خمکاری (Bending Cell)'); ?>">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/BendingCells/UplImg_35_68_358.jpg" alt="<?php pll_e('سلول های خمکاری (Bending Cell)'); ?>">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/BendingCells/UplImg_35_68_359.jpg" alt="<?php pll_e('سلول های خمکاری (Bending Cell)'); ?>">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/BendingCells/UplImg_35_68_360.jpg" alt="<?php pll_e('سلول های خمکاری (Bending Cell)'); ?>">
                        </div>
                    </div>
                    <a class="carousel-control-prev" href="#Bending-Cells-carousel" role="button" data-slide="prev">
                        <i class="fa fa-angle-<?php if(is_rtl()){ ?>right<?php } else { ?>left<?php } ?> fa-3x" aria-hidden="true"></i>
                        <span class="sr-only">Previous</span>
                    </a>
                    <a class="carousel-control-next" href="#Bending-Cells-carousel" role="button" data-slide="next">
                        <i class="fa fa-angle-<?php if(is_rtl()){ ?>left<?php } else { ?>right<?php } ?> fa-3x" aria-hidden="true"></i>
                        <span class="sr-only">Next</span>
                    </a>
                </div>
            </div>
            <div class="col-lg-6 px-5" <?php if(is_rtl()){ ?>dir="rtl"<?php } else { ?>dir="ltr"<?php } ?>>
                <ul class="list-simple py-5">
                    <li class="font-weight-bold"> <?php pll_e('راه حل های به صورت سفارشی طراحی شده'); ?> </li>
                    <li> <?php pll_e('سیستم تولید اتوماتیک'); ?> </li>
                    <li> <?php pll_e('حداکثر بهره وری'); ?> </li>
                    <li> <?php pll_e('دقت و تکرارپذیری خمکاری عالی'); ?> </li>
                    <li> <?php pll_e('عملیات مداوم'); ?> </li>
                    <li> <?php pll_e('راه حل های دردسترس'); ?> </li>
                </ul>
            </div>
        </div>
        <div class="my-5 py-5"></div>
        <div class="row title">
            <div class="col-sm-12 mb-2">
                <div class="animation-slide-up">
                    <h3 class="text-right text-blue font-weight-bold mb-0"><?php pll_e('راه حل های سفارشی'); ?></h3>
                </div>
                <div class="clearfix">
                    <hr class="w-25 float-right">
                    <i class="fa fa-angle-double-left fa-2x float-right" aria-hidden="true"></i>
                </div>
            </div>
        </div>
        <div class="row mb-5" dir="rtl">
            <div class="col-lg-6 px-5" <?php if(is_rtl()){ ?>dir="rtl"<?php } else { ?>dir="ltr"<?php } ?>>
                <ul class="list-simple pt-3 pb-2">
                    <li class="font-weight-bold"> <?php pll_e('راه حل های منحصر به فرد برای نیازهای خاص'); ?></li>
                    <li> <?php pll_e('پروژه برای نیازهای خاص شما طراحی می گردد'); ?> </li>
                    <li> <?php pll_e('برای اندازه های بزرگ و ضخامت های زیاد'); ?> </li>
                    <li> <?php pll_e('پشتیبانی فنی عالی'); ?> </li>
                    <li> <?php pll_e('تیم توسعه و مدیریت Adira در خدمت شما'); ?> </li>
                    <li> <?php pll_e('نتایج عالی تجربه ی فنی طولانی تولیدات Adira'); ?>  </li>
                </ul>
            </div>
            <div class="col-lg-6 px-5 py-4 py-lg-0" <?php if(is_rtl()){ ?>dir="rtl"<?php } else { ?>dir="ltr"<?php } ?>>
                <div id="Customized-solutions-carousel" class="navbar-change carousel slide" data-ride="carousel" data-interval="3000" data-pause="hover">
                    <ol class="carousel-indicators">
                        <li data-target="#Customized-solutions-carousel" data-slide-to="0" class="active"></li>
                        <li data-target="#Customized-solutions-carousel" data-slide-to="1"></li>
                        <li data-target="#Customized-solutions-carousel" data-slide-to="2"></li>
                        <li data-target="#Customized-solutions-carousel" data-slide-to="3"></li>
                        <li data-target="#Customized-solutions-carousel" data-slide-to="4"></li>
                        <li data-target="#Customized-solutions-carousel" data-slide-to="5"></li>
                        <li data-target="#Customized-solutions-carousel" data-slide-to="6"></li>
                        <li data-target="#Customized-solutions-carousel" data-slide-to="7"></li>
                    </ol>
                    <div class="carousel-inner">
                        <div class="carousel-item active">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/Customized solutions/UplImg_35_69_361.jpg" alt="<?php pll_e('راه حل های سفارشی'); ?>">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/Customized solutions/UplImg_35_69_362.jpg" alt="<?php pll_e('راه حل های سفارشی'); ?>">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/Customized solutions/UplImg_35_69_363.jpg" alt="<?php pll_e('راه حل های سفارشی'); ?>">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/Customized solutions/UplImg_35_69_364.jpg" alt="<?php pll_e('راه حل های سفارشی'); ?>">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/Customized solutions/UplImg_35_69_365.jpg" alt="<?php pll_e('راه حل های سفارشی'); ?>">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/Customized solutions/UplImg_35_69_366.jpg" alt="<?php pll_e('راه حل های سفارشی'); ?>">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/Customized solutions/UplImg_35_69_367.jpg" alt="<?php pll_e('راه حل های سفارشی'); ?>">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/Customized solutions/UplImg_35_69_536.jpg" alt="<?php pll_e('راه حل های سفارشی'); ?>">
                        </div>
                    </div>
                    <a class="carousel-control-prev" href="#Customized-solutions-carousel" role="button" data-slide="prev">
                        <i class="fa fa-angle-<?php if(is_rtl()){ ?>right<?php } else { ?>left<?php } ?> fa-3x" aria-hidden="true"></i>
                        <span class="sr-only">Previous</span>
                    </a>
                    <a class="carousel-control-next" href="#Customized-solutions-carousel" role="button" data-slide="next">
                        <i class="fa fa-angle-<?php if(is_rtl()){ ?>left<?php } else { ?>right<?php } ?> fa-3x" aria-hidden="true"></i>
                        <span class="sr-only">Next</span>
                    </a>
                </div>
            </div>
        </div>
        <div class="my-5 py-5"></div>
    </div>
<?php
get_footer();
